<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Post;

use Erlage\Photogram\Data\Dtos\Post\PostMetaHashtagsDTO;
use Erlage\Photogram\Data\Dtos\Post\PostDisplayContentDTO;

trait TraitPostGetters
{
    use TraitPostProperties;

    final public function getId(): string
    {
        return $this -> id;
    }

    public function getOwnerUserId(): string
    {
        return $this -> ownerUserId;
    }

    public function getDisplayCaption(): string
    {
        return $this -> displayCaption;
    }

    public function getDisplayLocation(): string
    {
        return $this -> displayLocation;
    }

    public function getDisplayContent(): PostDisplayContentDTO
    {
        return $this -> displayContent;
    }

    public function getMetaHashtags(): PostMetaHashtagsDTO
    {
        return $this -> metaHashtags;
    }

    public function getCacheLikesCount(): string
    {
        return $this -> cacheLikesCount;
    }

    public function getCacheCommentsCount(): string
    {
        return $this -> cacheCommentsCount;
    }

    public function getStampRegistration(): string
    {
        return $this -> stampRegistration;
    }

    public function getStampLastUpdate(): string
    {
        return $this -> stampLastUpdate;
    }
}
